/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.api.VWException;
import filenet.vw.toolkit.utils.VWUrlConnection;

public class VWKeepAlive
implements Runnable {
    private long m_lKeepAliveMilliseconds;
    private VWUrlConnection m_vwUrlConnection;
    private volatile Thread m_workerThread;

    public VWKeepAlive(String appServerUrl, long lKeepAliveRate) throws VWException {
        this.m_lKeepAliveMilliseconds = lKeepAliveRate * 60000L;
        this.m_vwUrlConnection = new VWUrlConnection(appServerUrl);
        this.m_workerThread = new Thread((Runnable)this, "VWKeepAlive");
        this.m_workerThread.start();
    }

    public void destroy() {
        if (this.m_workerThread != null) {
            Thread workerRef = this.m_workerThread;
            this.m_workerThread = null;
            workerRef.interrupt();
        }
    }

    public void run() {
        try {
            Thread thisThread = Thread.currentThread();
            while (thisThread.equals(this.m_workerThread)) {
                Thread.sleep(this.m_lKeepAliveMilliseconds);
                if (this.m_vwUrlConnection != null) {
                    this.m_vwUrlConnection.sendCommand(null, null);
                    continue;
                }
                System.out.println("Null URL connection");
            }
        }
        catch (InterruptedException ex) {
        }
        catch (Exception ex) {
            System.out.println("Exception in run: " + ex.getMessage());
        }
    }
}

